<?php
// Simple cache-busting helper: version by file modification time
if (!function_exists('asset_ver')) {
    function asset_ver($relPath) {
        $full = __DIR__ . '/' . ltrim($relPath, '/');
        return file_exists($full) ? filemtime($full) : time();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Professional IP Address Information Checker - Comprehensive analysis of IPv4 and IPv6 addresses with privacy, security, and geolocation data">
    <meta name="keywords" content="IP checker, IP lookup, geolocation, IP privacy, security analysis, VPN detection, proxy detection">
    <meta name="author" content="Professional Web Developer">
    <meta name="robots" content="index, follow">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:title" content="Professional IP Address Information Checker">
    <meta property="og:description" content="Comprehensive IP analysis tool with privacy scoring, security analysis, and detailed geolocation information">
    <meta property="og:url" content="">
    
    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:title" content="Professional IP Address Information Checker">
    <meta property="twitter:description" content="Comprehensive IP analysis tool with privacy scoring and security analysis">
    
    <title>Professional IP Address Information Checker - Advanced Analytics Tool</title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="data:image/svg+xml,<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 100 100'><text y='0.9em' font-size='90'>🌐</text></svg>">
    
    <!-- PWA Manifest -->
    <link rel="manifest" href="manifest.json">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="apple-mobile-web-app-title" content="IP Checker">
    <link rel="apple-touch-icon" href="data:image/svg+xml,<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 100 100'><rect width='100' height='100' fill='%234f46e5'/><text x='50' y='60' font-size='50' text-anchor='middle' fill='white'>🌐</text></svg>">
    
    <!-- External Resources - Optimized -->
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" media="print" onload="this.media='all'" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Fira+Code:wght@400;500;600&display=swap" rel="stylesheet">
    
    <!-- Preload Critical Resources (with cache-busting) -->
    <link rel="preload" href="assets/css/style.css?v=<?php echo asset_ver('assets/css/style.css'); ?>" as="style">
    <link rel="preload" href="assets/js/config.js?v=<?php echo asset_ver('assets/js/config.js'); ?>" as="script">
    <link rel="preload" href="assets/js/utils.js?v=<?php echo asset_ver('assets/js/utils.js'); ?>" as="script">
    <link rel="preload" href="assets/js/app.js?v=<?php echo asset_ver('assets/js/app.js'); ?>" as="script">
    
    <!-- DNS Prefetch for API domains (optimized) -->
    <link rel="dns-prefetch" href="//ip-api.com">
    <link rel="dns-prefetch" href="//ipinfo.io">
    <link rel="dns-prefetch" href="//ipapi.co">
    <link rel="dns-prefetch" href="//ip-whois.net">
    <link rel="dns-prefetch" href="//api.ip2location.io">
    
    <!-- Local Stylesheets (with cache-busting) -->
    <link rel="stylesheet" href="assets/css/style.css?v=<?php echo asset_ver('assets/css/style.css'); ?>">
    
    <style>
        /* Additional inline styles for above-the-fold content */
        /* Green/Black loading splash (no border radius) */
        .loading-splash { position: fixed; inset: 0; background: linear-gradient(180deg, #000 0%, #07110a 100%); display: flex; align-items: center; justify-content: center; z-index: 9999; transition: opacity 0.5s ease-out; }
        .loading-splash.hidden { opacity: 0; pointer-events: none; }
        .splash-content { text-align: center; color: #c8facc; }
    .splash-spinner { width: 240px; height: 6px; margin: 0 auto 16px; background: linear-gradient(90deg, rgba(0,255,136,0.06), #00ff88, rgba(0,255,136,0.06)); background-size: 200% 100%; animation: loadingBar 1.2s linear infinite; }
        @keyframes loadingBar { 0% { background-position: 200% 0; } 100% { background-position: -200% 0; } }
    </style>
</head>
<body>
    <!-- Loading Splash Screen -->
    <div class="loading-splash" id="loadingSplash">
        <div class="splash-content loading-box">
            <div class="splash-spinner"></div>
            <p class="loading-text">Initializing modules...</p>
        </div>
    </div>

    <div class="container">
        <!-- Header Section -->
        <header class="header">
            <h1>IP-Analyzer</h1>
            
            <!-- Current IP Display - Simple 3 Row Layout -->
            <div class="current-ip-simple" id="currentIpGrid">
                <!-- Row 1: IPv4 -->
                <div class="current-ip-row">
                    <div class="current-ip-main">
                        <div class="current-ip-label">
                            <i class="fas fa-wifi"></i> IPv4:
                        </div>
                        <strong class="current-ip-value" id="myIpv4">Detecting...</strong>
                    </div>
                </div>
                
                <!-- Row 2: IPv6 -->
                <div class="current-ip-row">
                    <div class="current-ip-main">
                        <div class="current-ip-label">
                            <i class="fas fa-wifi"></i> IPv6:
                        </div>
                        <strong class="current-ip-value" id="myIpv6">Detecting...</strong>
                    </div>
                </div>
                
                <!-- Row 3: Location -->
                <div class="current-ip-row">
                    <div class="current-ip-main">
                        <div class="current-ip-label">
                            <i class="fas fa-map-marker-alt"></i> Location:
                        </div>
                        <strong class="current-ip-value" id="myLocation">Detecting...</strong>
                    </div>
                </div>
            </div>
        </header>

        <!-- Main Content -->
        <main class="main-content">

            <!-- Card: Analisis IP -->
            <section class="result-card" id="analysisCard">
                <div class="card-header">
                    <h3><i class="fas fa-search"></i> IP Analysis</h3>
                </div>
                <div class="card-body" id="analysisBody">
                    <div class="input-group">
                        <div class="input-wrapper">
                            <label for="ipInput">
                                Enter IP Address (IPv4 or IPv6)
                            </label>
                            <input 
                                type="text" 
                                id="ipInput" 
                                placeholder="Example: 8.8.8.8 or 2001:4860:4860::8888 or 1.1.1.1" 
                                autocomplete="off"
                                spellcheck="false"
                            />
                        </div>
                        <div class="input-actions">
                            <button class="btn btn-primary" id="checkBtn">Analyze IP</button>
                        </div>
                    </div>

                    <!-- Loading State (moved inside Analisis IP card) -->
                    <div class="loading" id="loading">
                        <div class="loading-box">
                            <div class="spinner"></div>
                            <p class="loading-text">Analyzing...</p>
                        </div>
                    </div>

                    <!-- Error Message (moved inside Analisis IP card) -->
                    <div class="error-message" id="errorMessage"></div>

                    <!-- Results Section (moved inside Analisis IP card) -->
                    <div class="results" id="results">
                        <!-- Summary Card (Rangkuman) -->
                        <div class="result-card collapsible-card" id="card-summary">
                            <div class="card-header">
                                <button class="toggle-btn" data-target="#card-summary">Hide</button>
                                <h3><i class="fas fa-list"></i> Summary</h3>
                            </div>
                            <div class="card-body">
                                <div class="info-grid" id="summaryInfo"></div>
                            </div>
                        </div>

                        <!-- Basic Information Card -->
                        <div class="result-card collapsible-card collapsed" id="card-basic">
                            <div class="card-header">
                                <button class="toggle-btn" data-target="#card-basic">Show</button>
                                <h3><i class="fas fa-info-circle"></i> Basic Information</h3>
                            </div>
                            <div class="card-body" style="display:none;">
                                <div class="info-grid" id="basicInfo"></div>
                            </div>
                        </div>

                        <!-- Location Information Card -->
                        <div class="result-card collapsible-card collapsed" id="card-location">
                            <div class="card-header">
                                <button class="toggle-btn" data-target="#card-location">Show</button>
                                <h3><i class="fas fa-map-marker-alt"></i> Geographic Location</h3>
                            </div>
                            <div class="card-body" style="display:none;">
                                <div class="info-grid" id="locationInfo"></div>
                            </div>
                        </div>

                        <!-- Network Information Card -->
                        <div class="result-card collapsible-card collapsed" id="card-network">
                            <div class="card-header">
                                <button class="toggle-btn" data-target="#card-network">Show</button>
                                <h3><i class="fas fa-building"></i> ISP & Network Information</h3>
                            </div>
                            <div class="card-body" style="display:none;">
                                <div class="info-grid" id="networkInfo"></div>
                            </div>
                        </div>

                        <!-- Security Analysis Card -->
                        <div class="result-card collapsible-card collapsed" id="card-security">
                            <div class="card-header">
                                <button class="toggle-btn" data-target="#card-security">Show</button>
                                <h3><i class="fas fa-shield-alt"></i> Security Analysis</h3>
                            </div>
                            <div class="card-body" style="display:none;">
                                <div class="info-grid" id="securityInfo"></div>
                            </div>
                        </div>

                        <!-- Privacy Analysis Card -->
                        <div class="result-card collapsible-card collapsed" id="card-privacy">
                            <div class="card-header">
                                <button class="toggle-btn" data-target="#card-privacy">Show</button>
                                <h3><i class="fas fa-user-secret"></i> Privacy Analysis <span class="feature-badge">Advanced</span></h3>
                            </div>
                            <div class="card-body" style="display:none;">
                                <div id="privacyInfo"></div>
                            </div>
                        </div>

                        <!-- Interactive Map -->
                        <div class="result-card collapsible-card collapsed map-container" id="card-map">
                            <div class="card-header">
                                <button class="toggle-btn" data-target="#card-map">Show</button>
                                <h3><i class="fas fa-globe-americas"></i> Interactive Location Map</h3>
                            </div>
                            <div class="card-body" style="display:none;">
                                <div id="map"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <!-- API Status (styled like other cards) -->
            <section class="result-card api-status collapsible-card collapsed" id="apiStatus">
                <div class="card-header">
                    <button class="toggle-btn" data-target="#apiStatus">Show</button>
                    <h3><i class="fas fa-server"></i> API Status & Performance</h3>
                </div>
                <div class="card-body" style="display:none;">
                    <div class="api-grid" id="apiStatusList"></div>
                </div>
            </section>

            <!-- History removed for public build -->
        </main>

        <!-- Footer -->
        <footer class="footer" style="padding: 20px; text-align: center; border-top: 1px solid var(--accent-green); margin-top: 40px; color: var(--gray-600); font-size: 0.9rem;">
            <div class="footer-inner">
                <div class="footer-line"><strong>2025 IP Analyzer</strong></div>
                <div class="footer-line"><small>Advanced IP checker with privacy analysis, security scoring, and detailed geolocation for IPv4 and IPv6.</small></div>
            </div>
        </footer>
    </div>

    <!-- External Scripts - Deferred -->
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js" defer></script>
    
    <!-- Local Scripts - Optimized loading (with cache-busting) -->
    <script src="assets/js/config.js?v=<?php echo asset_ver('assets/js/config.js'); ?>" defer></script>
    <script src="assets/js/utils.js?v=<?php echo asset_ver('assets/js/utils.js'); ?>" defer></script>
    <script src="assets/js/app.js?v=<?php echo asset_ver('assets/js/app.js'); ?>" defer></script>
    
    <!-- Initialization Script -->
    <script>
        // Hide loading splash when page is fully loaded
        window.addEventListener('load', function() {
            setTimeout(() => {
                const splash = document.getElementById('loadingSplash');
                if (splash) {
                    splash.classList.add('hidden');
                    setTimeout(() => {
                        splash.style.display = 'none';
                    }, 500);
                }
            }, 900);
        });

        // Service Worker Registration for PWA features (optional)
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', function() {
                // Uncomment below to enable service worker
                // navigator.serviceWorker.register('/sw.js');
            });
        }

        // Performance monitoring
        window.addEventListener('load', function() {
            if (window.performance && window.performance.timing) {
                const loadTime = window.performance.timing.loadEventEnd - window.performance.timing.navigationStart;
                console.log('Page load time:', loadTime + 'ms');
            }
        });

        // Error handling for uncaught errors
        window.addEventListener('error', function(e) {
            console.error('Global error:', e.error);
            // Could send to analytics service
        });

        // Handle unhandled promise rejections
        window.addEventListener('unhandledrejection', function(e) {
            console.error('Unhandled promise rejection:', e.reason);
            e.preventDefault();
        });
    </script>
</body>
</html>
